/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.command;

import com.ibm.hsc.client.HSCCECClient;
import com.ibm.hsc.client.HSCClientObjectFactory;
import com.ibm.hsc.command.HMCCommandUtils;
import com.ibm.hsc.command.HMCCommands;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.HSCException;
import com.ibm.hsc.common.exceptions.RequiredParameterException;
import com.ibm.websm.diagnostics.IDebug;
import java.io.File;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;

public class ProfileDataBackup
implements HMCCommands {
    private HSCCECClient hcc = null;
    private String managedSystem;
    private String fileName;

    private void initializeClients() throws HSCException {
        HSCClientObjectFactory hSCClientObjectFactory = null;
        InetAddress inetAddress = null;
        String string = null;
        String string2 = null;
        try {
            inetAddress = InetAddress.getLocalHost();
            string2 = inetAddress.getHostName();
        }
        catch (Exception exception) {
            throw new HSCException(exception);
        }
        hSCClientObjectFactory = HSCClientObjectFactory.getInstance(string2, null);
        this.hcc = hSCClientObjectFactory.createCECClient(this.managedSystem, false);
        if (null == this.hcc) {
            string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "MANAGED_SYSTEM_NOT_FOUND");
            throw new HSCException(string);
        }
    }

    private void checkRequiredParameters() throws HSCException, RequiredParameterException {
        String string = null;
        String string2 = null;
        Object[] objectArray = null;
        if (this.managedSystem == null || this.fileName == null) {
            objectArray = new String[]{HMCCommandUtils.MANAGED_SYSTEM_PARAM + " " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND", "and", objectArray) + " " + HMCCommandUtils.FILE_PARAM};
            string = "The command entered is either missing a required parameter or a parameter value is invalid. The required parameters for this command are {0}. Please check your entry and retry the command.";
            string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS", string, objectArray);
            throw new RequiredParameterException(string2);
        }
    }

    private void validateParameterValues() throws HSCException, RequiredParameterException {
        File file = null;
        String string = null;
        String string2 = null;
        Object[] objectArray = null;
        file = new File(this.fileName);
        if (file.exists()) {
            string = "An error occurred while trying to perform this command. A profile with the file name specified already exists. Please change the file name and retry the command.";
            string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_FILE_ALREADY_EXISTS", string, objectArray);
            throw new RequiredParameterException(string2);
        }
    }

    public void performCommand() throws HSCException, RequiredParameterException {
        String string = null;
        this.checkRequiredParameters();
        this.validateParameterValues();
        this.initializeClients();
        if (!this.fileName.substring(0, 1).equals("/")) {
            string = this.hcc.getIntName();
            this.fileName = "/var/hsc/profiles/" + string + "/" + this.fileName;
        }
        this.hcc.backUpProfileData(this.fileName);
    }

    public void mapParameters(HashMap hashMap) throws RequiredParameterException {
        this.managedSystem = (String)hashMap.get(HMCCommandUtils.MANAGED_SYSTEM_PARAM);
        this.fileName = (String)hashMap.get(HMCCommandUtils.FILE_PARAM);
    }

    public void printResults() {
    }

    public void printHelp() {
        System.out.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "BACK_UP_PROFILE_HELP"));
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = null;
        ProfileDataBackup profileDataBackup = new ProfileDataBackup();
        try {
            String string2 = null;
            if (0 == stringArray.length) {
                profileDataBackup.printHelp();
            }
            int n = 0;
            while (n < stringArray.length) {
                string2 = stringArray[n];
                arrayList.add(string2);
                if (string2.equals(HMCCommandUtils.HELP_PARAM)) {
                    profileDataBackup.printHelp();
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                HashMap hashMap = HMCCommandUtils.parseParameters(arrayList);
                profileDataBackup.mapParameters(hashMap);
                profileDataBackup.performCommand();
            }
        }
        catch (HSCException hSCException) {
            if (IDebug.enabled()) {
                hSCException.printStackTrace();
            }
            if ((string = hSCException.getMessage()) == null) {
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR");
            }
            System.out.println(string);
            System.exit(1);
        }
        catch (RequiredParameterException requiredParameterException) {
            if (IDebug.enabled()) {
                requiredParameterException.printStackTrace();
            }
            if ((string = requiredParameterException.getMessage()) == null) {
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS");
            }
            System.out.println(string);
            System.exit(1);
        }
        catch (Exception exception) {
            if (IDebug.enabled()) {
                exception.printStackTrace();
            }
            System.out.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR"));
            System.exit(1);
        }
        System.exit(0);
    }
}

